


if ~exist('avgangrb')
	AAE_QualityControl();
end

raintimes = {...
	[2016,04,26,23,17,00], [2016,04,27,03,30,00];...
	[2016,04,29,12,40,00], [2016,04,29,14,31,00];...
	[2016,04,29,18,20,00], [2016,04,29,19,14,00];...
	[2016,05,10,00,47,00], [2016,05,10,01,32,00];...
	[2016,05,13,22,49,00], [2016,05,14,00,31,00];... %high Im(RI)
	[2016,05,16,06,25,00], [2016,05,16,09,03,00];... %high Im(RI)
	[2016,05,16,15,17,00], [2016,05,16,16,52,00];...
	[2016,05,17,04,13,00], [2016,05,17,07,02,00]};   %low Im(RI)


% could be avgred or redfilt, try and fix accordingly
kred = avgred   .* (1e6./100) .* 660 .* (1e-7) ./ (4.*pi());
kblue = avgblue .* (1e6./100) .* 470 .* (1e-7) ./ (4.*pi());



for r = 1:length(raintimes)
	%% Average AAE At Rain Start
	[~,curr_rainstartidx_PSAP] = min(abs(datenum(PSAPtime) - datenum(raintimes{r,1})));
	[~,curr_rainendidx_PSAP] = min(abs(datenum(PSAPtime) - datenum(raintimes{r,2})));
	
	[~,curr_rainstartidx_PSAPavg] = min(abs(datenum(avgPSAPtime) - datenum(raintimes{r,1})));
	[~,curr_rainendidx_PSAPavg] = min(abs(datenum(avgPSAPtime) - datenum(raintimes{r,2})));
	
	AAE_table(r,1) = nanmean(newrawRBang(curr_rainstartidx_PSAP:curr_rainendidx_PSAP));
	avgAAE_table(r,1) = nanmean(avgangrb(curr_rainstartidx_PSAPavg:curr_rainendidx_PSAPavg));
	
	AAE_ktable(r,1) = kred(curr_rainendidx_PSAPavg);
	AAE_ktable(r,2) = kblue(curr_rainendidx_PSAPavg);
	
	
end
